/***************************************************************************/
/*  USART 0 driver for the NXP LPC1xxx microcontrollers.                   */
/***************************************************************************/
#include "global.h"                          				// LPC11U6x definitions

const char ascii[] = "0123456789ABCDEF";

void USART0_Init(uint32_t baudrate)
{
	uint32_t brd = (SystemCoreClock / (baudrate << 4));

  Chip_IOCON_PinMuxSet(LPC_IOCON, 0,18 , 0x00000081);	// UART RXD
  Chip_IOCON_PinMuxSet(LPC_IOCON, 0,19 , 0x00000081);	// UART TXD

  Chip_UART0_Init(LPC_USART0);							// Enable USART clock
  LPC_SYSCTL->USART0CLKDIV   = 1;            			// divided by 1

  LPC_USART0->FCR = 0x07;                    			// Enable and reset TX and RX FIFO
  LPC_USART0->LCR = 0x83;                    			// 8 bits, no Parity, 1 Stop bit
  LPC_USART0->DLL = (brd & 0xFF);            			// Set baud rate dividers
  LPC_USART0->DLM = (brd >> 8);              			//
  LPC_USART0->LCR = 0x03;                    			// DLAB = 0
}

char ua_inchar(void)	                         // look if there is a character available
{
    if (LPC_USART0->LSR & 1)
        return LPC_USART0->RBR & 0x7F;         // yes, return character from input buffer
    else
        return 0xFF;                           // no, return -1
}

char ua_getchar(void)                          // this function waits for a character
{
    while (!(LPC_USART0->LSR & 0x1));
    return LPC_USART0->RBR & 0x7F;             // Read character from input buffer
}

void ua_outchar(char c)		
{
    LPC_USART0->THR = c;
    while(!(LPC_USART0->LSR & 0x40));
}

void PrintByte(unsigned char b)
{
    ua_outchar(ascii[b >> 4]);
    ua_outchar(ascii[b & 0x0f]);
}

void PrintWord(unsigned short w)
{
    PrintByte((unsigned char)(w>>8));
    PrintByte((unsigned char)w);
}

//void PrintLong(long l)
//{
//    PrintWord((WORD)(l>>16));
//    PrintWord((WORD)l);
//}

void PrintBDecimal(unsigned char b)
{
  unsigned char p;

    p = ascii[b / 10];
    if (p != '0')
        ua_outchar(p);
    ua_outchar(ascii[b % 10]);
}

void PrintWDecimal(unsigned short w)
{
    ua_outchar(ascii[w / 10000]);
    w %= 10000;
    ua_outchar(ascii[w / 1000]);
    w %= 1000;
    ua_outchar(ascii[w / 100]);
    w %= 100;
    ua_outchar(ascii[w / 10]);
    ua_outchar(ascii[w % 10]);
}

void PrintString(const char *s)
{
    while (*s)
    {
        if (*s == '\n')
            ua_outchar('\r');                  // output a '\r' first
        ua_outchar(*s);
        s++;
    }
}
